/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.globalsetting.service.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import com.tp_link.eap.domain.portal.PortalWebUIElement;
import com.tp_link.eap.domain.portal.PortalWebUIPicture;
import com.tp_link.eap.monitor.cloud.proxy.a.a;
import com.tp_link.eap.monitor.globalsetting.service.i;
import com.tp_link.eap.monitor.portal.repo.PortalWebUIElementRepository;
import com.tp_link.eap.monitor.portal.repo.PortalWebUIPictureRepository;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

@Component(value="portalWebUIElementService")
public class PortalWebUIElementService
implements i {
    private static final Logger a = LoggerFactory.getLogger(PortalWebUIElementService.class);
    @Autowired
    private PortalWebUIElementRepository b;
    @Autowired
    private PortalWebUIPictureRepository c;
    @Autowired
    private MongoDbFactory d;

    @Override
    public void delGridFSFileById(ObjectId fileId) {
        GridFS gridFS = new GridFS(this.d.getDb());
        a.debug("delete: fileId=" + fileId);
        gridFS.remove(fileId);
    }

    @Override
    public GridFSInputFile saveGridFSFile(InputStream in) {
        GridFS gridFS = new GridFS(this.d.getDb());
        GridFSInputFile gridFSInputFile = gridFS.createFile(in);
        gridFSInputFile.save();
        return gridFSInputFile;
    }

    public GridFSInputFile saveGridFSFileWithFileId(InputStream in, String fileId) {
        GridFS gridFS = new GridFS(this.d.getDb());
        GridFSInputFile gridFSInputFile = gridFS.createFile(in);
        gridFSInputFile.setId((Object)new ObjectId(fileId));
        gridFSInputFile.save();
        return gridFSInputFile;
    }

    public GridFSDBFile loadGridFSFileById(ObjectId fileObjId) {
        BasicDBObject basicDBObject = new BasicDBObject("_id", (Object)fileObjId);
        GridFS gridFS = new GridFS(this.d.getDb());
        GridFSDBFile gridFSDBFile = gridFS.findOne((DBObject)basicDBObject);
        return gridFSDBFile;
    }

    @Override
    public String addPictureFileToGridfs(byte[] rawFile) {
        if (this.checkGridFsReachMaxSize()) {
            a.warn("Map picture has reached maximum size");
            return null;
        }
        String string = "";
        try {
            GridFSInputFile gridFSInputFile = this.saveGridFSFile(new ByteArrayInputStream(rawFile));
            if (gridFSInputFile == null) {
                a.error("saveGridFSFile failed!");
                return null;
            }
            string = gridFSInputFile.getId().toString();
            PortalWebUIPicture portalWebUIPicture = new PortalWebUIPicture();
            portalWebUIPicture.setId(null);
            portalWebUIPicture.setFileId(string);
            portalWebUIPicture.setTemp(true);
            portalWebUIPicture.setExpiredTime(System.currentTimeMillis() + 1800000L);
            this.c.save(portalWebUIPicture);
            return string;
        }
        catch (Exception exception) {
            a.error("save file failed!");
            return null;
        }
    }

    @Override
    public String addPictureFileToGridfs(HttpServletRequest request, long pictureSizeMax) {
        CommonsMultipartResolver commonsMultipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        String string = "";
        if (commonsMultipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            Iterator iterator = multipartHttpServletRequest.getFileNames();
            while (iterator.hasNext()) {
                MultipartFile multipartFile = multipartHttpServletRequest.getFile((String)iterator.next());
                if (multipartFile == null) continue;
                try {
                    if (multipartFile.getSize() > pictureSizeMax) {
                        return "large";
                    }
                    GridFSInputFile gridFSInputFile = this.saveGridFSFile(multipartFile.getInputStream());
                    if (gridFSInputFile == null) {
                        a.error("saveGridFSFile failed!");
                        return null;
                    }
                    string = gridFSInputFile.getId().toString();
                    PortalWebUIPicture portalWebUIPicture = new PortalWebUIPicture();
                    portalWebUIPicture.setId(null);
                    portalWebUIPicture.setFileId(string);
                    portalWebUIPicture.setTemp(true);
                    portalWebUIPicture.setExpiredTime(System.currentTimeMillis() + 1800000L);
                    this.c.save(portalWebUIPicture);
                    return string;
                }
                catch (IOException | IllegalStateException exception) {
                    a.error("Exception occured!");
                    return null;
                }
            }
            a.error("Not found any part?");
            return null;
        }
        a.error("Not Multipart!");
        return null;
    }

    @Override
    public boolean getPictureFileFromGridfs(String fileId, HttpServletResponse response) {
        GridFSDBFile gridFSDBFile = this.loadGridFSFileById(new ObjectId(fileId));
        if (null == gridFSDBFile) {
            return false;
        }
        try {
            ServletOutputStream servletOutputStream = response.getOutputStream();
            gridFSDBFile.writeTo((OutputStream)servletOutputStream);
            servletOutputStream.flush();
            return true;
        }
        catch (Exception exception) {
            a.warn(exception.toString(), (Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean getFileFromGridfsByCloud(String fileId, ChannelHandlerContext ctx, String transferId) {
        GridFSDBFile gridFSDBFile = this.loadGridFSFileById(new ObjectId(fileId));
        if (null == gridFSDBFile) {
            return false;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            gridFSDBFile.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])byArray);
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, byteBuf);
            defaultFullHttpResponse.headers().set(HttpHeaders.Names.CONNECTION, (Object)HttpHeaders.Values.KEEP_ALIVE);
            defaultFullHttpResponse.headers().set((CharSequence)"X-Transfer-Id", (Object)transferId);
            defaultFullHttpResponse.headers().set(HttpHeaders.Names.CONTENT_LENGTH, (Object)byArray.length);
            if (a.isDebugEnabled()) {
                a.debug("File size is {}, content length is {}", (Object)gridFSDBFile.getLength(), (Object)byArray.length);
            }
            com.tp_link.eap.monitor.cloud.proxy.a.a.a(ctx, defaultFullHttpResponse);
            return true;
        }
        catch (Exception exception) {
            a.warn(exception.toString(), (Throwable)exception);
            return false;
        }
    }

    @Override
    public String getPictureBase64FileFromGridfs(String fileId) {
        GridFSDBFile gridFSDBFile = this.loadGridFSFileById(new ObjectId(fileId));
        if (null == gridFSDBFile) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gridFSDBFile.writeTo((OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string = bASE64Encoder.encode(byArray);
        return string;
    }

    @Override
    public boolean savePictureBase64FileToGridfs(String fileId, String base64Data) {
        if (null == fileId || null == base64Data) {
            return false;
        }
        try {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray = bASE64Decoder.decodeBuffer(base64Data);
            GridFSInputFile gridFSInputFile = this.saveGridFSFileWithFileId(new ByteArrayInputStream(byArray), fileId);
            if (gridFSInputFile == null) {
                a.error("saveGridFSFile failed!");
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            a.error("save file failed!");
            return false;
        }
    }

    @Override
    public void savePictureRecord(PortalWebUIPicture portalWebUIPicture) {
        if (null != portalWebUIPicture) {
            this.c.save(portalWebUIPicture);
        }
    }

    @Override
    public void delPictureFileFromGridfs(String fileId) {
        if (e.a((String)fileId)) {
            a.warn("fileId is null");
            return;
        }
        this.delGridFSFileById(new ObjectId(fileId));
        PortalWebUIPicture portalWebUIPicture = this.c.findByFileId(fileId);
        if (null != portalWebUIPicture) {
            this.c.delete((Serializable)((Object)portalWebUIPicture.getId()));
        }
    }

    @Override
    public List<PortalWebUIPicture> getFormalPictureRecords() {
        List list = com.tp_link.eap.util.a.a.a(this.c.findByTemp(false));
        return list;
    }

    @Override
    public void readjustPictureFile() {
        List list = com.tp_link.eap.util.a.a.a((Iterable)this.c.findAll());
        if (null != list) {
            for (PortalWebUIPicture portalWebUIPicture : list) {
                if (!portalWebUIPicture.isTemp() || portalWebUIPicture.getExpiredTime() > System.currentTimeMillis()) continue;
                this.delPictureFileFromGridfs(portalWebUIPicture.getFileId());
            }
        }
    }

    @Override
    public void delPictureRecordByFileId(String fileId) {
        PortalWebUIPicture portalWebUIPicture;
        if (null != fileId && null != (portalWebUIPicture = this.c.findByFileId(fileId))) {
            this.c.delete(portalWebUIPicture);
        }
    }

    @Override
    public void deleteAllRecordsAndFiles() {
        List list = com.tp_link.eap.util.a.a.a((Iterable)this.c.findAll());
        if (null == list) {
            return;
        }
        for (PortalWebUIPicture portalWebUIPicture : list) {
            this.delPictureFileFromGridfs(portalWebUIPicture.getFileId());
        }
    }

    @Override
    public boolean addPortalWebUIElement(PortalWebUIElement entry) {
        String string = entry.getId();
        if (e.a((String)string)) {
            entry.setId(null);
            this.b.save(entry);
            return true;
        }
        return false;
    }

    @Override
    public PortalWebUIElement getPortalWebUIElementByPortalId(String portalId) {
        if (e.a((String)portalId)) {
            return null;
        }
        return this.b.findByPortalId(portalId);
    }

    @Override
    public PortalWebUIElement getPortalWebUIElementById(String id) {
        if (e.a((String)id)) {
            return null;
        }
        return this.b.findById(id);
    }

    @Override
    public void delPortalWebUIElementById(String id) {
        this.b.delete((Serializable)((Object)id));
    }

    @Override
    public void delPortalWebUIElementByPortalId(String portalId) {
        PortalWebUIElement portalWebUIElement = null;
        Object var3_3 = null;
        try {
            portalWebUIElement = this.b.findByPortalId(portalId);
            if (null != portalWebUIElement) {
                if (!e.a((String)portalWebUIElement.getBackgroundPictureId())) {
                    this.delPictureFileFromGridfs(portalWebUIElement.getBackgroundPictureId());
                }
                if (!e.a((String)portalWebUIElement.getLogoPictureId())) {
                    this.delPictureFileFromGridfs(portalWebUIElement.getLogoPictureId());
                }
                String string = null;
                for (int i2 = 0; i2 < portalWebUIElement.getAdPictureIdList().size(); ++i2) {
                    string = (String)portalWebUIElement.getAdPictureIdList().get(i2);
                    if (e.a((String)string)) continue;
                    this.delPictureFileFromGridfs(string);
                }
            }
            this.b.delete(portalWebUIElement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            a.error("delete portal failed!");
        }
    }

    @Override
    public boolean savePortalWebUIElement(PortalWebUIElement entry) {
        this.b.save(entry);
        return true;
    }

    @Override
    public void portalPictureLoad(HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return;
        }
        String string = jSONObject.optString("fileId");
        if (e.a((String)string)) {
            a.warn("fileId is null");
            response.setStatus(404);
        } else {
            a.debug("Load: fileId {}", (Object)string);
            try {
                boolean bl = this.getPictureFileFromGridfs(string, response);
                if (!bl) {
                    a.warn("Load picture falied {}", (Object)string);
                    response.setStatus(404);
                }
            }
            catch (Exception exception) {
                a.warn(exception.toString(), (Throwable)exception);
                response.setStatus(404);
            }
        }
    }

    @Override
    public OperationResponse portalPictureLoad(String transferId, ControlType controlType, JSONObject reqObj, ChannelHandlerContext ctx) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("fileId");
        if (e.a((String)string)) {
            a.warn("fileId is null");
            return com.tp_link.eap.util.e.aZ;
        }
        a.debug("Load: fileId {}", (Object)string);
        try {
            boolean bl = this.getFileFromGridfsByCloud(string, ctx, transferId);
            if (bl) {
                a.debug("Load picture by cloud success {}", (Object)string);
                return com.tp_link.eap.util.e.bd;
            }
        }
        catch (Exception exception) {
            a.warn(exception.toString(), (Throwable)exception);
            return com.tp_link.eap.util.e.aY;
        }
        a.warn("Load portal picture by cloud falied {}", (Object)string);
        return com.tp_link.eap.util.e.aY;
    }

    @Override
    public OperationResponse portalWebUIConvertedRawPictureUpload(HttpServletRequest request, HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        if (this.checkGridFsReachMaxSize()) {
            return new OperationResponse(ResErrorCode.bI);
        }
        try {
            String string = this.addPictureFileToGridfs(request, com.tp_link.eap.util.e.eK);
            if (null == string) {
                return com.tp_link.eap.util.e.bg;
            }
            if (string.equals("large")) {
                return new OperationResponse(ResErrorCode.bl);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("fileId", string);
            return new OperationResponse(ResErrorCode.a, "Upload picture succeeded!", hashMap);
        }
        catch (Exception exception) {
            a.error("proc save file failed!");
            return com.tp_link.eap.util.e.bg;
        }
    }

    @Override
    public OperationResponse portalWebUIConvertedRawPictureUpload(ControlType controlType, JSONObject reqData, String fileName, byte[] fileContent) {
        try {
            if ((long)fileContent.length > com.tp_link.eap.util.e.eK) {
                a.warn("Too large({}) converted picture file of portal", (Object)fileContent.length);
                return new OperationResponse(ResErrorCode.bl);
            }
            if (this.checkGridFsReachMaxSize()) {
                return new OperationResponse(ResErrorCode.bI);
            }
            GridFSInputFile gridFSInputFile = this.saveGridFSFile(new ByteArrayInputStream(fileContent));
            if (gridFSInputFile == null) {
                a.warn("Failed to saveGridFSFile for portal picture from cloud");
                return com.tp_link.eap.util.e.bg;
            }
            String string = gridFSInputFile.getId().toString();
            PortalWebUIPicture portalWebUIPicture = new PortalWebUIPicture();
            portalWebUIPicture.setId(null);
            portalWebUIPicture.setFileId(string);
            portalWebUIPicture.setTemp(true);
            portalWebUIPicture.setExpiredTime(System.currentTimeMillis() + 1800000L);
            this.c.save(portalWebUIPicture);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("fileId", string);
            return new OperationResponse(ResErrorCode.a, "Upload picture succeeded!", hashMap);
        }
        catch (Exception exception) {
            a.error("proc save file failed!");
            return com.tp_link.eap.util.e.bg;
        }
    }

    @Override
    public OperationResponse portalRawPictureUpload(HttpServletRequest request, HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        if (this.checkGridFsReachMaxSize()) {
            return new OperationResponse(ResErrorCode.bI);
        }
        try {
            String string = this.addPictureFileToGridfs(request, com.tp_link.eap.util.e.eJ);
            if (null == string) {
                return com.tp_link.eap.util.e.bg;
            }
            if (string.equals("large")) {
                return new OperationResponse(ResErrorCode.bt);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("fileId", string);
            return new OperationResponse(ResErrorCode.a, "Upload picture succeeded!", hashMap);
        }
        catch (Exception exception) {
            a.error("proc save file failed!");
            return com.tp_link.eap.util.e.bg;
        }
    }

    @Override
    public OperationResponse portalRawPictureUpload(ControlType controlType, JSONObject reqData, String fileName, byte[] fileContent) {
        try {
            if ((long)fileContent.length > com.tp_link.eap.util.e.eJ) {
                a.warn("Too large({}) picture file of portal", (Object)fileContent.length);
                return new OperationResponse(ResErrorCode.bt);
            }
            if (this.checkGridFsReachMaxSize()) {
                return new OperationResponse(ResErrorCode.bI);
            }
            GridFSInputFile gridFSInputFile = this.saveGridFSFile(new ByteArrayInputStream(fileContent));
            if (gridFSInputFile == null) {
                a.warn("Failed to saveGridFSFile for portal picture from cloud");
                return com.tp_link.eap.util.e.bg;
            }
            String string = gridFSInputFile.getId().toString();
            PortalWebUIPicture portalWebUIPicture = new PortalWebUIPicture();
            portalWebUIPicture.setId(null);
            portalWebUIPicture.setFileId(string);
            portalWebUIPicture.setTemp(true);
            portalWebUIPicture.setExpiredTime(System.currentTimeMillis() + 1800000L);
            this.c.save(portalWebUIPicture);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("fileId", string);
            return new OperationResponse(ResErrorCode.a, "Upload picture succeeded!", hashMap);
        }
        catch (Exception exception) {
            a.error("proc save file failed!");
            return com.tp_link.eap.util.e.bg;
        }
    }

    @Override
    public OperationResponse deletePortalPictureList(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        JSONArray jSONArray = jSONObject.optJSONArray("fileIdArray");
        List list = JSONArray.toList((JSONArray)jSONArray, (Object)new String(), (JsonConfig)new JsonConfig());
        for (String string : list) {
            OperationResponse operationResponse;
            if (e.a((String)string) || (operationResponse = this.a(string)).success()) continue;
            return com.tp_link.eap.util.e.bg;
        }
        return new OperationResponse(ResErrorCode.a, "Delete picture list succeeded", null);
    }

    @Override
    public OperationResponse deletePortalPicture(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("fileId", null);
        return this.a(string);
    }

    private OperationResponse a(String string) {
        if (e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        a.debug("delete fileId = {}", (Object)string);
        try {
            this.delPictureFileFromGridfs(string);
        }
        catch (Exception exception) {
            return com.tp_link.eap.util.e.bg;
        }
        return new OperationResponse(ResErrorCode.a, "Delete picture succeeded", (Object)string);
    }

    @Override
    public boolean checkGridFsReachMaxSize() {
        if (l.b()) {
            return false;
        }
        try {
            CommandResult commandResult = this.d.getDb().getCollection("fs.chunks").getStats();
            if (!commandResult.containsField("size")) {
                return false;
            }
            int n2 = commandResult.getInt("size");
            a.debug("Now size is {}", (Object)n2);
            return (long)n2 >= 0x8000000L;
        }
        catch (NullPointerException nullPointerException) {
            a.warn(nullPointerException.toString(), (Throwable)nullPointerException);
            return true;
        }
    }
}

